<?php
$mc_brand = defined('MOORES_BRAND') ? MOORES_BRAND : '';
$mc_byline = defined('MOORES_BYLINE') ? MOORES_BYLINE : '';
$mc_location = defined('MOORES_LOCATION') ? MOORES_LOCATION : '';
$mc_phone = defined('MOORES_PHONE') ? MOORES_PHONE : '';
$mc_hours_weekdays = defined('MOORES_HOURS_WEEKDAYS') ? MOORES_HOURS_WEEKDAYS : '';
$mc_hours_saturday = defined('MOORES_HOURS_SATURDAY') ? MOORES_HOURS_SATURDAY : '';
?>

<footer class="footer" id="contact">
	<div class="container-wide">
		<hr class="sep">
		<small><strong><?php echo esc_html($mc_brand); ?></strong> — <?php echo esc_html($mc_location); ?></small>
		<small>Phone: <?php echo esc_html($mc_phone); ?> | Weekdays: <?php echo esc_html($mc_hours_weekdays); ?> | Sat: <?php echo esc_html($mc_hours_saturday); ?></small>
		<small>© <?php echo date('Y'); ?> <?php echo esc_html($mc_brand); ?> — Powered by <?php echo esc_html($mc_byline); ?></small>
	</div>
</footer>

<?php
	$mc_phone_raw = $mc_phone ? preg_replace('/[^0-9+]/', '', $mc_phone) : '';
?>
<div class="mc-mobile-actions" role="navigation" aria-label="Quick actions">
	<a class="mc-mobile-action" href="tel:<?php echo esc_attr($mc_phone_raw); ?>">Call</a>
	<a class="mc-mobile-action" href="#work">Gallery</a>
	<button class="mc-mobile-action" type="button" data-auth-open>Login</button>
	<a class="mc-mobile-action mc-mobile-action-primary" href="#contact">Quote</a>
</div>

<script>
(() => {
	const header = document.querySelector('.mc-header');
	const toggle = document.querySelector('.mc-nav-toggle');
	if (!header || !toggle) return;

	const closeNav = () => {
		header.classList.remove('nav-open');
		toggle.setAttribute('aria-expanded', 'false');
		toggle.setAttribute('aria-label', 'Open menu');
	};

	toggle.addEventListener('click', () => {
		const isOpen = header.classList.toggle('nav-open');
		toggle.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
		toggle.setAttribute('aria-label', isOpen ? 'Close menu' : 'Open menu');
	});

	header.querySelectorAll('.mc-menu a').forEach((link) => {
		link.addEventListener('click', closeNav);
	});

	document.addEventListener('click', (event) => {
		if (!header.classList.contains('nav-open')) return;
		if (header.contains(event.target)) return;
		closeNav();
	});
})();
</script>

<?php wp_footer(); ?>
</body>
</html>
